function CDX = set_L_total(CDX, L_total, dates)
% --------------------------------------------------------------------------------------------------
% Set fraction of idiosyncratic and systematic jump intensities
% --------------------------------------------------------------------------------------------------
% CDX       ... credit index structure (see 'all_steps_in_a_row.m')
% L_total   ... time-series of L_idio+L_Y
% dates     ... dates for which to set parameters, if L_total of of length > 1
% --------------------------------------------------------------------------------------------------
% sample call: set_L_total(CDX_NA_IG, 1);
% --------------------------------------------------------------------------------------------------

% Get time series of omega1
omega1 = CDX.AJD_common_factor.L ./ (CDX.AJD_common_factor.L + CDX.portfolio(1).AJD.L);

% Use fixed (i.e. time-homogenous parameter)
if (nargin == 2)
    % Set value for common factor
    CDX.AJD_common_factor.L = omega1 * L_total;
    
    % Set value for individual CDS
    for i=1:length(CDX.portfolio)
        CDX.portfolio(i).AJD.L = (1 - omega1) .* L_total;
    end
    return
end

% Switch from fixed to time-varying parameters (only done once)
if (length(omega1) < length(L_total))
    if (length(omega1) == 1)
        omega1 = repmat(omega1, length(L_total), 1);
        CDX.AJD_common_factor.L = repmat(CDX.AJD_common_factor.L, length(CDX.dates{1}), 1);
        for i=1:length(CDX.portfolio)
            cds = CDX.portfolio(i);
            cds.AJD.L = repmat(cds.AJD.L, length(cds.dates{1}), 1);
            CDX.portfolio(i) = cds;
        end
    else
        error('Parameter dimensions for L_total not consistend.');
    end
end

% Set value for common factor
[trash, used_pos_cdx, used_pos_params] = intersect_sorted(CDX.dates{1}, dates);
CDX.AJD_common_factor.L(used_pos_cdx,:) = omega1(used_pos_cdx) .* L_total(used_pos_params);

% Set value for individual CDS
for i=1:length(CDX.portfolio)
    % Determine matching dates
    cds = CDX.portfolio(i);
    [trash, used_pos_cdx, used_pos_cds, used_pos_params] = intersect_triple(CDX.dates{1}, cds.dates{1}, dates);
    if (length(used_pos_cds) > 0)
        cds.AJD.L(used_pos_cds,:) = (1 - omega1(used_pos_cdx)) .* L_total(used_pos_params);
        CDX.portfolio(i) = cds;
    end
    clear trash used_pos_cds used_pos_params
end